﻿using Connection;
using Connection.Class;
using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading;
using System.Windows.Forms;
using WBP_Home;
using WBP_Home.Class;
using System.Reflection;
using System.IO;
using System.Security.Cryptography;
using System.Data.SqlTypes;

namespace WBP_Home_API_Demo_Customer
{

    public partial class Form1 : Form
    {

        private static WBP_Home.WBP_Home Home;
        private bool HomeAUIFlag = false;
        private bool ReadBPMSetting2Flag = false;

        public Form1()
        {
            InitializeComponent();
            System.Reflection.Assembly assembly = System.Reflection.Assembly.GetExecutingAssembly();
            var WBP_HomeInfo = System.Reflection.Assembly.GetAssembly(typeof(WBP_Home.WBP_Home)).GetName();
            Text = $"{assembly.GetName().Name}  v{assembly.GetName().Version}           {WBP_HomeInfo.Name}  v{WBP_HomeInfo.Version}";


            //init BPM Setting 2

            textBox_infPressure.Text = "180";
            textBox_BAtteryf.Text = "0";
            comboBox_BaudRate.SelectedIndex = 1;
            textBox_OffsetYear.Text = "0";
            comboBox_MapCorrection.SelectedIndex = 0;
            comboBox_Rxwakeup.SelectedIndex = 0;
            comboBox_WBPUI.SelectedIndex = 1;
            comboBox_diagnostic_mode_results.SelectedIndex = 0;
            comboBox_Bluetooth_function.SelectedIndex = 1;
            comboBoxBluetooth_UI.SelectedIndex = 1;
            comboBox_FactoryTest.SelectedIndex = 0;
        }



        private void Form1_Load(object sender, EventArgs e)
        {
            comboBox1.SelectedIndex = 0;
            comboBox_Usual.SelectedIndex = 0;
            comboBox_Diagnostic.SelectedIndex = 0;
        }

        private void Home_OnReceived(Command command)
        {
            StringBuilder sb = new StringBuilder();
            if (command.CMD == (byte)WBP_Home.Enum.Command.CasualData_include_each_Read_Progress)
            {
                richTextBox1.BeginInvoke((MethodInvoker)delegate {
                    Progress_Data progress = (Progress_Data)command.Data;
                    sb.Append(progress.Receive.ToString() + "/" + progress.Total.ToString() + "\r\n");
                    richTextBox1.Text = sb.ToString();
                });
                return;
            }
            switch (command.CMD)
            {
                case (byte)WBP_Home.Enum.Command.ID_Read:
                    string Device_ID = (String)command.Data;
                    sb.Append("Read ID:" + Device_ID);
                    SetControlPropertyThreadSafe(textBox_OrgID, "Text", Device_ID);
                    break;
                case (byte)WBP_Home.Enum.Command.ID_WriteAndClearData:
                    sb.Append("Write id and clear data success");
                    break;
                case (byte)WBP_Home.Enum.Command.DeviceDateTime_Read:
                    dateTimePicker1.BeginInvoke((MethodInvoker)delegate {
                        dateTimePicker1.Value = ((DateTimeOffset)command.Data).DateTime;
                    });
                    sb.Append("DeviceDateTime:" + ((DateTimeOffset)command.Data).DateTime.ToString());
                    break;
                case (byte)WBP_Home.Enum.Command.DateTime_Write:
                    sb.Append("Write TIme Success");
                    break;
                case (byte)WBP_Home.Enum.Command.CasualData_Read:
                    if (command.Data is List<Data>)
                    {
                        List<Data> CasualData = (List<Data>)command.Data;
                        if (CasualData.Count > 0)
                        {
                            sb.Append("\t" + "\t" + "\t");
                            sb.Append("\t" + "Sys" + "\t" + "Dia" + "\t" + "Hr" + "\t" + "Arr");
                            sb.Append("\r\n");
                            int i = 0;
                            for (i = 0; i < CasualData.Count - 1; i++)
                            {
                                sb.Append(i.ToString() + "\t" + CasualData[i].MeasureDateTime.ToString("yyyy-MM-dd") + "\t" + CasualData[i].MeasureDateTime.ToString("HH:mm:ss"));
                                sb.Append("\t" + CasualData[i].Systole.ToString() + "\t" + CasualData[i].Diastole.ToString() + "\t" + CasualData[i].Pulse.ToString() + "\t" + CasualData[i].Arr.ToString());
                                sb.Append("\r\n");
                            }
                            sb.Append("average \r\n");
                            i = CasualData.Count - 1;
                            sb.Append(i.ToString() + "\t" + CasualData[i].MeasureDateTime.ToString("yyyy-MM-dd") + "\t" + CasualData[i].MeasureDateTime.ToString("HH:mm:ss"));
                            sb.Append("\t" + CasualData[i].Systole.ToString() + "\t" + CasualData[i].Diastole.ToString() + "\t" + CasualData[i].Pulse.ToString());
                            sb.Append("\r\n");
                        }
                        else
                        {
                            sb.Append("No Casual Data");
                        }
                    }
                    else if (command.Data is WBP_Home.Enum.ErrorCode.ParseDateError)
                    {
                        sb.Append("Parse Date Error");
                    }
                    break;
                case (byte)WBP_Home.Enum.Command.CasualData_include_each_Read:
                    if (command.Data is UsualDataWithEachMeasurements)
                    {
                        UsualDataWithEachMeasurements Data = (UsualDataWithEachMeasurements)command.Data;
                        sb.Append("Mode:" + Data.Mode.ToString() + "\r\n");
                        sb.Append("History_Data_Number:" + Data.History_Data_Number.ToString() + "\r\n");

                        sb.Append("MData\r\n");

                        sb.Append("\t" + "\t" + "\t");
                        sb.Append("\t" + "Sys_Avg" + "\t" + "Dia_avg" + "\t" + "Hr_avg" + "\t" + "Afib" + "\t" + "Type");
                        sb.Append("\t" + "Sys_1" + "\t" + "Dia_1" + "\t" + "Hr_1" + "\t" + "AF1");
                        sb.Append("\t" + "Sys_2" + "\t" + "Dia_2" + "\t" + "Hr_2" + "\t" + "AF2");
                        sb.Append("\t" + "Sys_3" + "\t" + "Dia_3" + "\t" + "Hr_3" + "\t" + "AF3");
                        sb.Append("\r\n");

                        for (int i = 0; i < Data.MData.Count; i++)
                        {
                            sb.Append(i.ToString() + "\t" + Data.MData[i].MeasureDateTime.ToString("yyyy-MM-dd") + "\t" + Data.MData[i].MeasureDateTime.ToString("HH:mm:ss"));
                            sb.Append("\t" + Data.MData[i].SystoleAvg.ToString() + "\t" + Data.MData[i].DiastoleAvg.ToString() + "\t" + Data.MData[i].PulseAvg.ToString() + "\t" + Data.MData[i].Arr.ToString() + "\t" + Data.MData[i].DataType.ToString());
                            sb.Append("\t" + Data.MData[i].Sys1.ToString() + "\t" + Data.MData[i].Dia1.ToString() + "\t" + Data.MData[i].Pulse1.ToString() + "\t" + Data.MData[i].AF1.ToString());
                            sb.Append("\t" + Data.MData[i].Sys2.ToString() + "\t" + Data.MData[i].Dia2.ToString() + "\t" + Data.MData[i].Pulse2.ToString() + "\t" + Data.MData[i].AF2.ToString());
                            sb.Append("\t" + Data.MData[i].Sys3.ToString() + "\t" + Data.MData[i].Dia3.ToString() + "\t" + Data.MData[i].Pulse3.ToString() + "\t" + Data.MData[i].AF3.ToString());
                            sb.Append("\r\n");
                        }
                    }
                    else if (command.Data is WBP_Home.Enum.ErrorCode.ParseDateError)
                    {
                        sb.Append("Parse Date Error");
                    }
                    break;
                case (byte)WBP_Home.Enum.Command.DiagnosticData_Read:
                    if (command.Data is List<Data>)
                    {
                        List<Data> DiagnosticData = (List<Data>)command.Data;
                        if (DiagnosticData.Count >= 3)
                        {
                            sb.Append("\t" + "\t" + "\t");
                            sb.Append("\t" + "Sys" + "\t" + "Dia" + "\t" + "Hr" + "\t" + "Arr");
                            sb.Append("\r\n");
                            int i = 0;
                            for (i = 0; i < DiagnosticData.Count - 3; i++)
                            {
                                if (DiagnosticData[i].Systole > 0)
                                {
                                    sb.Append(i.ToString() + "\t" + DiagnosticData[i].MeasureDateTime.ToString("yyyy-MM-dd") + "\t" + DiagnosticData[i].MeasureDateTime.ToString("HH:mm:ss"));
                                    sb.Append("\t" + DiagnosticData[i].Systole.ToString() + "\t" + DiagnosticData[i].Diastole.ToString() + "\t" + DiagnosticData[i].Pulse.ToString() + "\t" + DiagnosticData[i].Arr.ToString());
                                    sb.Append("\r\n");
                                }
                            }
                            for (i = DiagnosticData.Count - 3; i < DiagnosticData.Count; i++)
                            {
                                sb.Append("average" + "\t" + DiagnosticData[i].DateType.ToString() + "\t" + "\t");
                                sb.Append("\t" + DiagnosticData[i].Systole.ToString() + "\t" + DiagnosticData[i].Diastole.ToString() + "\t" + DiagnosticData[i].Pulse.ToString() + "\t");
                                sb.Append("\r\n");
                            }
                        }
                        else
                        {
                            sb.Append("No Diagnostic Data");
                        }
                    }
                    else if (command.Data is WBP_Home.Enum.ErrorCode.ParseDateError)
                    {
                        sb.Append("Parse Date Error");
                    }
                    break;
                case (byte)WBP_Home.Enum.Command.DeviceVer_Read:
                    GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    break;
                case (byte)WBP_Home.Enum.Command.MemoryIndex_Read:
                    GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    break;
                case (byte)WBP_Home.Enum.Command.BPMSetting_Read:
                    GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    break;
                case (byte)WBP_Home.Enum.Command.SingleMemoryDataByIndex_Read:
                    if (command.Data is WBP_Home.Enum.ErrorCode.ParseDateError)
                    {
                        sb.Append("Parse Date Error");
                    }
                    else
                        GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    break;
                case (byte)WBP_Home.Enum.Command.BPMSetting2_Read:
                    BPMSetting2 data = (BPMSetting2)command.Data;
                    GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    richTextBox1.BeginInvoke((MethodInvoker)delegate {
                        textBox_infPressure.Text = data.HI_infPressure.ToString();
                        textBox_BAtteryf.Text = data.Batteryf.ToString();
                        comboBox_BaudRate.SelectedIndex = (int)data.BaudRate - 3;
                        textBox_OffsetYear.Text = data.OffsetYear.ToString();
                        comboBox_MapCorrection.SelectedIndex = Convert.ToInt32(data.Setting3.MAPCorrection);
                        comboBox_Rxwakeup.SelectedIndex = Convert.ToInt32(data.Setting3.RxWakeup);
                        comboBox_WBPUI.SelectedIndex = Convert.ToInt32(data.Setting3.HomeAUI);
                        comboBox_diagnostic_mode_results.SelectedIndex = Convert.ToInt32(data.Setting3.HideDiagnosticModeResults);
                        comboBox_Bluetooth_function.SelectedIndex = Convert.ToInt32(data.Setting3.Bluetooth);
                        comboBoxBluetooth_UI.SelectedIndex = Convert.ToInt32(data.Setting3.Bluetooth_NewUI);
                        comboBox_FactoryTest.SelectedIndex = Convert.ToInt32(data.Setting3.FactoryTest);
                    });
                    ReadBPMSetting2Flag = true;
                    if (data.Setting3.HomeAUI)
                        HomeAUIFlag = true;
                    else
                        HomeAUIFlag = false;
                    break;

                case (byte)WBP_Home.Enum.Command.SN_Read:
                    GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    textBox_SN.BeginInvoke((MethodInvoker)delegate {
                        textBox_SN.Text = command.Data.ToString();
                    });
                    break;
                case (byte)WBP_Home.Enum.Command.Device_ID_Read:
                    GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    textBox_Device_ID.BeginInvoke((MethodInvoker)delegate {
                        textBox_Device_ID.Text = command.Data.ToString();
                    });
                    break;
                case (byte)WBP_Home.Enum.Command.Measurement_setting_Read:
                    GlobalFunction.PrintAllProperties(command, ref sb, append: true);
                    richTextBox1.BeginInvoke((MethodInvoker)delegate {
                        WBP_Home.Class.MeasurementSetting measurementSetting = (WBP_Home.Class.MeasurementSetting)command.Data;
                        comboBox_Measure_Times.SelectedItem = measurementSetting.MeasurementTimes.ToString();
                        comboBox_Rest_Time.SelectedIndex = ((int)measurementSetting.RestTime);
                        comboBox_Interval_Time.SelectedIndex = ((int)measurementSetting.IntervalTime);
                        comboBox_ExcludeAverage.SelectedIndex = Convert.ToInt32(measurementSetting.ExcludeAverage);
                        comboBox_SWAfib.SelectedIndex = Convert.ToInt32(measurementSetting.SW_Afib);
                    });
                    break;
                case (byte)WBP_Home.Enum.Command.Measurement_setting_Change:
                    sb.Append("Measurement setting Change Success");
                    break;
                case (byte)WBP_Home.Enum.Command.Nack:
                    sb.Append("Nack");
                    break;
            }
            SetRichTextBox1String(sb);


        }

        private void SetRichTextBox1String(StringBuilder sb)
        {
            richTextBox1.BeginInvoke((MethodInvoker)delegate {
                richTextBox1.Focus();
                richTextBox1.Text = sb.ToString();
            });
        }
        private delegate void SetControlPropertyThreadSafeDelegate(
        Control control,
        string propertyName,
        object propertyValue);

        public static void SetControlPropertyThreadSafe(
            Control control,
            string propertyName,
            object propertyValue)
        {
            if (control.InvokeRequired)
            {
                control.Invoke(new SetControlPropertyThreadSafeDelegate
                (SetControlPropertyThreadSafe),
                new object[] { control, propertyName, propertyValue });
            }
            else
            {
                control.GetType().InvokeMember(
                    propertyName,
                    BindingFlags.SetProperty,
                    null,
                    control,
                    new object[] { propertyValue });
            }
        }

        private void Home_OnConnected()
        {
            Label_DevicePath.Invoke((MethodInvoker)delegate {
                try
                {
                    Label_DevicePath.Text = Home.DevicePath;
                }
                catch { }
            });
            button_Send.Invoke((MethodInvoker)delegate {
                button_Send.Enabled = true;
            });
        }
        private void Home_OnDisConnected()
        {
            Label_DevicePath.Invoke((MethodInvoker)delegate {
                try
                {
                    Label_DevicePath.Text = "";
                }
                catch { }
            });
            button_Send.Invoke((MethodInvoker)delegate {
                button_Send.Enabled = false;
            });
            ReadBPMSetting2Flag = false;
        }

        private void button_Send_Click(object sender, EventArgs e)
        {
            richTextBox1.Text = "";
            if (comboBox1.SelectedIndex >= 15)
            {
                if (Home.WBP_Home_ver < WBP_Home.Enum.WBP_Home_Ver.BT014)
                {
                    richTextBox1.Text = "The command only supports BT014";
                    return;
                }
            }
            if (comboBox1.SelectedIndex >= 17)
            {
                if (!ReadBPMSetting2Flag)
                {
                    richTextBox1.Text = "Please use (F2h)Read BPM setting 2 first to confirm whether it is HomeA";
                    return;
                }
                else if (!HomeAUIFlag)
                {
                    richTextBox1.Text = "This command only supports WBP Home A";
                    return;
                }
            }
            switch (comboBox1.SelectedIndex)
            {
                case 0: //===All Version Support
                    break;
                case 1: //(3Eh)Request for the device name of the BPM
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.WatchBPHomeVersion_Read());
                    break;
                case 2: //(23h)Clear memory and Set ID String
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.ID_WriteAndClearData(textBox_UserID.Text,
                                    bool.Parse(comboBox_Usual.SelectedItem.ToString()),
                                    bool.Parse(comboBox_Diagnostic.SelectedItem.ToString())));
                    break;
                case 3: //(24h)Read ID String from PC
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.ID_Read());
                    break;
                case 4: //(26h)Read the device time
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.DateTime_Read());
                    break;
                case 5: //(27h)Set the device time
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.DateTime_Write(dateTimePicker1.Value));
                    break;
                case 6: //(28h)send the BP data format for the usual mode
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.CasualData_Read());
                    break;
                case 7: //(29h)send the BP data format for the diagnostic mode
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.DiagnosticData_Read());
                    break;
                case 8: //(F0h)Sent BPM setting
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.BPMSetting_Read());
                    break;
                case 9: //(F2h)Read BPM setting 2
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.BPMSetting2_Read());
                    break;
                case 10://===New version of BT011 support & BT014 support
                    break;
                case 11://(F8h)Read serial number
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.SN_Read());
                    break;
                case 12://(48h)send memory index (usual mode)
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.MemoryIndex_Read());
                    break;
                case 13://(49h)sent single memory data by index (usual mode)
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.SingleMemoryDataByIndex_Read(int.Parse(textBox_Memory_Index.Text)));
                    break;
                case 14://===BT014 support
                    break;
                case 15://(FAh)Read device ID
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.Device_ID_Read());
                    break;
                case 16://===BT014 Home A support
                    break;
                case 17://(32h)Sent usual mode memory include each measurements
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.CasualData_include_each_Read());
                    break;
                case 18://(50h)Change measurement setting
                    WBP_Home.Class.MeasurementSetting measurementSetting = new WBP_Home.Class.MeasurementSetting();
                    if (comboBox_Measure_Times.SelectedItem != null)
                        measurementSetting.MeasurementTimes = int.Parse((string)comboBox_Measure_Times.SelectedItem);
                    else
                        measurementSetting.MeasurementTimes = 0;
                    measurementSetting.RestTime = (WBP_Home.Enum.Measurement_Setting_Time)Convert.ToInt32(comboBox_Rest_Time.SelectedIndex);
                    measurementSetting.IntervalTime = (WBP_Home.Enum.Measurement_Setting_Time)Convert.ToInt32(comboBox_Interval_Time.SelectedIndex);
                    measurementSetting.ExcludeAverage = Convert.ToBoolean(comboBox_ExcludeAverage.SelectedIndex);
                    measurementSetting.SW_Afib = Convert.ToBoolean(comboBox_SWAfib.SelectedIndex);
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.Measurement_setting_Change(measurementSetting));
                    break;
                case 19://(51h)read measurement setting
                    Home.SendMessage(WBP_Home.SendMessage.ToCommand.Measurement_setting_Read());
                    break;
            }
        }


        private void Button_CheckKey_Click(object sender, EventArgs e)
        {
            try
            {
                Home = new WBP_Home.WBP_Home(textBox_key.Text);
                Home.OnConnected += Home_OnConnected;
                Home.OnReceived += Home_OnReceived;
                Home.OnDisConnected += Home_OnDisConnected;
                Home.InitDeviceWatcher();
                button_Send.Enabled = true;
                textBox_key.Enabled = false;
                (sender as Button).Enabled = false;
            }
            catch (Exception ee)
            {
                if (ee.Message == "Key Fail!")
                {
                    MessageBox.Show("Key Fail!");
                }
            }
        }
    }
}